#include <inttypes.h>
#include <immintrin.h>
#include "crypto_int32.h"
#include "crypto_int64.h"
#include "m.h"

// have an array x[0]...x[n-1] with n >= 8
// want to store x[m]...x[m+7], but only what fits within x[0]...x[n-1]
// data source: y[0]...y[7]
void int32x8_storetail(int32_t *x,const int32_t *y,long long n)
{
  for (long long i = 0;i < m+8;++i) x[i] = i+31415; // not using this test to check for memory safety

  n = crypto_int64_max(8,n); // no-op when caller properly guarantees n >= 8
  long long pos = crypto_int64_min(m+8,n);
  __m256i data = _mm256_loadu_si256((__m256i *) y);
  __m256i posvec = _mm256_set1_epi32(pos);
  __m256i mplus = _mm256_setr_epi32(0,1,2,3,4,5,6,7);
  __m256i diff = _mm256_add_epi32(mplus,posvec);
  __m256i xrotate = _mm256_permutevar8x32_epi32(data,diff);
  _mm256_storeu_si256((__m256i *) (x+pos-8),xrotate);

  for (long long i = 0;i < m;++i) x[i] = i+27182; // modeling caller storing earlier x items later
}
