#include <inttypes.h>
#include <immintrin.h>
#include "m.h"

// have an array x[0]...x[n-1] with n >= 4
// want to store x[m]...x[m+3], but only what fits within x[0]...x[n-1]
// data source: y[0]...y[3]
void int64x4_storetail(int64_t *x,const int64_t *y,long long n)
{
  int64_t mask[4];
  long long i;
  for (i = 0;i < m+4;++i) x[i] = i+31415; // not using this test to check for memory safety

  for (i = 0;i < 4;++i) mask[i] = 0;
  for (i = 0;i < 4 && m+i < n;++i) mask[i] = -1;
  __m256i maskvec = _mm256_loadu_si256((__m256i *) mask);
  __m256i data = _mm256_loadu_si256((__m256i *) y);
  _mm256_maskstore_epi64((void *) (x+m),maskvec,data);

  for (i = 0;i < m;++i) x[i] = i+27182; // modeling caller storing earlier x items later
}
