#include "crypto_int32.h"
#include "crypto_verify.h"

int crypto_verify(const unsigned char *x,const unsigned char *y)
{
  unsigned char differentbits = 0;
  int i;

  for (i = 0;i < crypto_verify_BYTES;++i)
    differentbits |= x[i] ^ y[i];

  return crypto_int32_nonzero_mask((crypto_int32) differentbits);
}
